<?php
/*
Plugin Name: SeedProd Notification Bar Pro
Plugin URI: https://www.seedprod.com
Description: The Ultimate WordPress Notification Bar Plugin
Version:  1.2.13
Author: SeedProd
Author URI: http://www.seedprod.com
TextDomain: seedprod-wp-notification-bar-pro
Domain Path: /languages
License: GPLv2
Copyright 2018 SeedProd LLC (email : john@seedprod.com, twitter : @seedprod)
*/

/**
 * Default Constants
 */
define( 'SEED_WPNB_SHORTNAME', 'seed_wpnb' ); // Used to reference namespace functions.
define( 'SEED_WPNB_SLUG', 'seedprod-notification-bar-pro/seedprod-notification-bar-pro.php' ); // Used for settings link.
define( 'SEED_WPNB_TEXTDOMAIN', 'seedprod-wp-notification-bar-pro' ); // Your textdomain
define( 'SEED_WPNB_PLUGIN_NAME', __( 'Notification Bar Pro', 'seedprod-notification-bar-pro' ) ); // Plugin Name shows up on the admin settings screen.
define( 'SEED_WPNB_VERSION', '1.2.13'); // Plugin Version Number.
define( 'SEED_WPNB_PLUGIN_PATH', plugin_dir_path( __FILE__ ) ); // Example output: /Applications/MAMP/htdocs/wordpress/wp-content/plugins/seed_wpnb/
define( 'SEED_WPNB_PLUGIN_URL', plugin_dir_url( __FILE__ ) ); // Example output: http://localhost:8888/wordpress/wp-content/plugins/seed_wpnb/
define( 'SEED_WPNB_SUBSCRIBERS_TABLENAME', 'wpnb_subscribers' );
define( 'SEED_WPNB_PAGES_TABLENAME', 'wpnb_pages' );
// define( 'SEED_WPNB_API_URL', 'http://api.seedprod.com/v3/update' );
// define( 'SEED_WPNB_THEME_API_URL', 'http://api.seedprod.com/v3/themes' );
// define( 'SEED_WPNB_BACKGROUND_API_URL', 'http://api.seedprod.com/v3/backgrounds' );
define( 'SEED_WPNB_THEME_BASE_URL', 'https://s3.amazonaws.com/static.seedprod.com/themes/' );
define( 'SEED_WPNB_API_URL', 'https://api.seedprod.com/v2/update' );
define( 'SEED_WPNB_THEME_API_URL', 'https://api.seedprod.com/v3/themes' );
define( 'SEED_WPNB_BACKGROUND_API_URL', 'https://api.seedprod.com/v3/backgrounds' );




/**
 * Load Translation
 */
function seed_wpnb_load_textdomain() {
    load_plugin_textdomain( 'seedprod-wp-notification-bar-pro', false, dirname( plugin_basename( __FILE__ ) ) . '/languages/' );
}
add_action('plugins_loaded', 'seed_wpnb_load_textdomain');


/**
 * Upon activation of the plugin set defaults
 */
function seed_wpnb_activation(){
  global $seed_wpnb_settings_defaults;
  require_once( SEED_WPNB_PLUGIN_PATH.'admin/default-settings.php' );

  add_option('seed_wpnb_settings_content',unserialize($seed_wpnb_settings_defaults['seed_wpnb_settings_content']));

  add_option('seed_wpnb_token',strtolower(wp_generate_password(32,false, false)));


  // seed_wpnb_add_rules();
  // flush_rewrite_rules();
}
register_activation_hook( __FILE__, 'seed_wpnb_activation' );





/***************************************************************************
 * Load Required Files
 ***************************************************************************/
// Global Settings Var
global $seed_wpnb_settings;

require_once( SEED_WPNB_PLUGIN_PATH.'admin/get-settings.php' );
$seed_wpnb_settings = seed_wpnb_get_settings();

// Class to render pages
require_once( SEED_WPNB_PLUGIN_PATH.'inc/class-seed-wpnb.php' );
add_action( 'plugins_loaded', array( 'SEED_WPNB', 'get_instance' ) );


if( is_admin() ) {
	// Admin Only
	require_once( SEED_WPNB_PLUGIN_PATH.'admin/config-settings.php' );
    require_once( SEED_WPNB_PLUGIN_PATH.'admin/admin.php' );
    // Load Admin
    add_action( 'plugins_loaded', array( 'SEED_WPNB_ADMIN', 'get_instance' ) );
} else {
	// Public only
}

// Welcome Page
if(!defined('SEED_WPNB_API_KEY')){
  register_activation_hook( __FILE__, 'seed_wpnb_welcome_screen_activate' );
}
function seed_wpnb_welcome_screen_activate() {
  set_transient( '_seed_wpnb_welcome_screen_activation_redirect', true, 30 );
}


if(!defined('SEED_WPNB_API_KEY')){
  add_action( 'admin_init', 'seed_wpnb_welcome_screen_do_activation_redirect' );
}
function seed_wpnb_welcome_screen_do_activation_redirect() {
  // Bail if no activation redirect
    if ( ! get_transient( '_seed_wpnb_welcome_screen_activation_redirect' ) ) {
    return;
  }

  // Delete the redirect transient
  delete_transient( '_seed_wpnb_welcome_screen_activation_redirect' );

  // Bail if activating from network, or bulk
  if ( is_network_admin() || isset( $_GET['activate-multi'] ) ) {
    return;
  }

  // Redirect to bbPress about page
  wp_safe_redirect( add_query_arg( array( 'page' => 'seed_wpnb_welcome' ), admin_url( 'options-general.php' ) ) );
}

if(!defined('SEED_WPNB_API_KEY')){
  add_action('admin_menu', 'seed_wpnb_welcome_screen_pages');
}

function seed_wpnb_welcome_screen_pages() {
  add_options_page(
    'Welcome To SeedProd',
    'Welcome To SeedProd',
    'read',
    'seed_wpnb_welcome',
    'seed_wpnb_welcome_screen_content'
  );
}

function seed_wpnb_welcome_screen_content() {
  require_once(SEED_WPNB_PLUGIN_PATH.'admin/license.php');
}
add_action( 'admin_head', 'seed_wpnb_welcome_screen_remove_menus' );
function seed_wpnb_welcome_screen_remove_menus() {
    remove_submenu_page( 'options-general.php', 'seed_wpnb_welcome' );
}

/**
 * SeedProd Functions
 */
require_once(SEED_WPNB_PLUGIN_PATH.'inc/functions.php');


// Api Updates

/**
* API Updates
*/

if( !class_exists( 'SeedProd_Updater_wpnb' ) ) {
    // load our custom updater
    include( dirname( __FILE__ ) . '/seedprod-updater-wpnb.php' );
}
function seed_wpnb_plugin_updater() {

    $seed_wpnb_api_key = '';
    $seed_emaillist = "";
    $seed_admin_email = get_option( 'admin_email','' );
    if(defined('SEED_WPNB_API_KEY')){
        $seed_wpnb_api_key = SEED_WPNB_API_KEY;
    }
    if(empty($seed_wpnb_api_key)){
        $seed_wpnb_api_key = get_option('seed_wpnb_license_key');
    }
    if(!empty($seed_cspv4['emaillist'])){
        $seed_emaillist = $seed_cspv4['emaillist'];
    }
    $data = array();
    $data['emaillist'] = $seed_emaillist;
    $data['admin_email'] = $seed_admin_email;
    // retrieve our license key from the DB
    //$license_key = trim( get_option( 'edd_sample_license_key' ) );
    // setup the updater

    $seedprod_updater = new SeedProd_Updater_wpnb( SEED_WPNB_API_URL, __FILE__, array(
            'license'   => $seed_wpnb_api_key,        // license key (used get_option above to retrieve from DB)
            'data'      => $data
        )
    );

}
add_action( 'admin_init', 'seed_wpnb_plugin_updater', 0 );




add_action( 'admin_head', 'seed_wpnb_set_user_settings' );
function seed_wpnb_set_user_settings() {
  if(isset($_GET['page']) && $_GET['page'] == 'seed_wpnb'){
              $user_id = get_current_user_id();
              $options = get_user_option( 'user-settings', $user_id );
              parse_str($options,$user_settings);
              $user_settings['imgsize'] = 'full';
              update_user_option( $user_id, 'user-settings', http_build_query($user_settings), false );
              update_user_option( $user_id, 'user-settings-time', time(), false );
  }
}



// Multisite Initial Install License Check
function seed_wpnb_check_license_updater(){
    if(get_option('seed_wpnb_a') === false){
    add_option('seed_wpnb_license_key',SEED_WPNB_API_KEY);
    add_option('seed_wpnb_token',strtolower(wp_generate_password(32,false, false)));

    $params = array(
        'action'     => 'info',
        'license_key'=> SEED_WPNB_API_KEY,
        'slug'       => SEED_WPNB_SLUG,
        'domain'        => home_url(),
        'installed_version' => SEED_WPNB_VERSION,
        'token'      => get_option('seed_wpnb_token'),
    );
    $request = wp_remote_post( SEED_WPNB_API_URL, array( 'timeout' => 15, 'sslverify' => false, 'body' => $params ) );
    if ( ! is_wp_error( $request ) ) {
                $request = wp_remote_retrieve_body( $request );
                $arequest = json_decode($request);
                $nag = $arequest->message;

                update_option('seed_wpnb_license_key',$api_key);
                
                update_option('seed_wpnb_api_message',$nag);
                if($arequest->status == '200'){
                    update_option('seed_wpnb_api_nag','');
                    update_option('seed_wpnb_a',true);
                    update_option('seed_wpnb_per',$arequest->per);
                }elseif($arequest->status == '401'){
                    update_option('seed_wpnb_api_nag',$nag);
                    update_option('seed_wpnb_a',false);
                    update_option('seed_wpnb_per','');
                }elseif($arequest->status == '402'){
                    update_option('seed_wpnb_api_nag',$nag);
                    update_option('seed_wpnb_a',false);
                    update_option('seed_wpnb_per',$arequest->per);

                }     


            }
    }
}

if(defined('SEED_WPNB_API_KEY')){
  if(isset($_GET['page']) && $_GET['page'] == 'seed_wpnb'){
    add_action( 'admin_init', 'seed_wpnb_check_license_updater');
  }
}

