<?php

/**
* Add to array if value does not exist
*/
function seed_wpnb_array_add($arr, $key, $value){
    if (!array_key_exists($key, $arr)) {

        $arr[$key] = $value;
    }
    return $arr;
}

/**
* Page default settings
*/
function seed_wpnb_get_page_default_settings(){
    $settings = array();
    // Default Block
    $blocks = array('description','form','countdown','social_profiles');
    if(!empty($settings->blocks)){
    foreach($block as $v){
        $settings->blocks = seed_wpnb_array_add($v);
    }
    $blocks = $settings->blocks;
    }

    //var_dump($settings);
    //die();

    $fields = array('name');

    $settings = seed_wpnb_array_add($settings,'call_to_action_txt', '');
    $settings = seed_wpnb_array_add($settings,'call_to_action_link', '');
    $settings = seed_wpnb_array_add($settings,'countdown_type', 'date');
    $settings = seed_wpnb_array_add($settings,'countdown_timer', '');
    $settings = seed_wpnb_array_add($settings,'bar_position', 'fixed');
    $settings = seed_wpnb_array_add($settings,'border_transparent', '1');
    $settings = seed_wpnb_array_add($settings,'show', '0');
    $settings = seed_wpnb_array_add($settings,'hide', '0');
    $settings = seed_wpnb_array_add($settings,'include_exclude_options', '0');
    $settings = seed_wpnb_array_add($settings,'parameter_name', '');
    $settings = seed_wpnb_array_add($settings,'parameter_value', '');

    $settings = seed_wpnb_array_add($settings,'enable_bar', '0');
    $settings = seed_wpnb_array_add($settings,'disabled_fields', '');
    $settings = seed_wpnb_array_add($settings,'typekit_id', '');
    $settings = seed_wpnb_array_add($settings,'publish_method', '');
    $settings = seed_wpnb_array_add($settings,'theme_css', '');
    $settings = seed_wpnb_array_add($settings,'custom_css', '');
    $settings = seed_wpnb_array_add($settings,'button_subset', '');
    $settings = seed_wpnb_array_add($settings,'fields',$fields);
    $settings = seed_wpnb_array_add($settings,'blocks',$blocks);
    $settings = seed_wpnb_array_add($settings,'logo','');
    $settings = seed_wpnb_array_add($settings,'headline','Notification Bar');
    $settings = seed_wpnb_array_add($settings,'description',"");
    $settings = seed_wpnb_array_add($settings,'emaillist','database');
    $settings = seed_wpnb_array_add($settings,'thankyou_msg','Thank You!');
    $settings = seed_wpnb_array_add($settings,'countdown_date','');
    $settings = seed_wpnb_array_add($settings,'countdown_timezone','US/Eastern');
    $settings = seed_wpnb_array_add($settings,'countdown_format','dHMS');
    $settings = seed_wpnb_array_add($settings,'social_profiles_size','');
    $settings = seed_wpnb_array_add($settings,'background_color','#FF5722');
    $settings = seed_wpnb_array_add($settings,'background_image','');
    $settings = seed_wpnb_array_add($settings,'enable_fitvid','1');
    $settings = seed_wpnb_array_add($settings,'headline_subset','');
    $settings = seed_wpnb_array_add($settings,'theme','0');
    $settings = seed_wpnb_array_add($settings,'social_profiles_blank','1');
    $settings = seed_wpnb_array_add($settings,'text_font','Open Sans');
    $settings = seed_wpnb_array_add($settings,'text_color','#ffffff');
    $settings = seed_wpnb_array_add($settings,'text_size','14');
    $settings = seed_wpnb_array_add($settings,'text_weight','400');
    $settings = seed_wpnb_array_add($settings,'text_line_height','1.5');
    $settings = seed_wpnb_array_add($settings,'text_subset','');
    $settings = seed_wpnb_array_add($settings,'button_font','Open Sans');
    $settings = seed_wpnb_array_add($settings,'button_color','#000000');
    $settings = seed_wpnb_array_add($settings,'element_border_color','#000000');
    $settings = seed_wpnb_array_add($settings,'form_border_color','#000000');
    $settings = seed_wpnb_array_add($settings,'form_color','#f5f5f5');
    $settings = seed_wpnb_array_add($settings,'button_size','14');
    $settings = seed_wpnb_array_add($settings,'button_weight','400');
    $settings = seed_wpnb_array_add($settings,'button_line_height','1');
    $settings = seed_wpnb_array_add($settings,'border_color','#ffffff');
    $settings = seed_wpnb_array_add($settings,'border_width','3');
    $settings = seed_wpnb_array_add($settings,'container_effect_animation','');
    $settings = seed_wpnb_array_add($settings,'txt_email_field','Email');
    $settings = seed_wpnb_array_add($settings,'txt_subscribe_button','Notify Me');
    $settings = seed_wpnb_array_add($settings,'txt_name_field','Name');
    $settings = seed_wpnb_array_add($settings,'txt_already_subscribed_msg',"You're already subscribed.");
    $settings = seed_wpnb_array_add($settings,'txt_invalid_email_msg','Invalid Email');
    $settings = seed_wpnb_array_add($settings,'txt_invalid_name_msg','Invalid Name');
    $settings = seed_wpnb_array_add($settings,'txt_countdown_days','Days');
    $settings = seed_wpnb_array_add($settings,'txt_countdown_day','Day');
    $settings = seed_wpnb_array_add($settings,'txt_countdown_hours','Hours');
    $settings = seed_wpnb_array_add($settings,'txt_countdown_hour','Hour');
    $settings = seed_wpnb_array_add($settings,'txt_countdown_minutes','Minutes');
    $settings = seed_wpnb_array_add($settings,'txt_countdown_minute','Minute');
    $settings = seed_wpnb_array_add($settings,'txt_countdown_seconds','Seconds');
    $settings = seed_wpnb_array_add($settings,'txt_countdown_second','Second');
    return $settings;
}


/**
* Check per
*/
function seed_wpnb_cu( $rper = null ) {
    if(!empty($rper)){
        $uper = explode(",", get_option('seed_wpnb_per'));
        if(in_array($rper,$uper)){
            return true;
        }else{
            return false;
        }
    }else{
        $a = get_option('seed_wpnb_a');
        if($a){
            return true;
        }else{
            return false;
        }
    }
}


/**
 * Get Plugin API value
 */
function seed_wpnb_get_plugin_api_value($k = null) {
    return false;
    global $seed_cspv4;
    extract($seed_cspv4);
    if(!empty($plugin_api)){
        $plugin_api = str_replace(array("\n\r","\n"), "&", $plugin_api);
        parse_str($plugin_api, $plugin_api);
        if(array_key_exists($k, $plugin_api)){
            return $plugin_api[$k];
        }else{
            return false;
        }

    }
}

/**
 *  Get IP
 */
function seed_wpnb_get_ip(){
    $ip = '';
    if( !empty($_SERVER['HTTP_X_FORWARDED_FOR']) AND strlen($_SERVER['HTTP_X_FORWARDED_FOR'])>6 ){
        $ip = strip_tags($_SERVER['HTTP_X_FORWARDED_FOR']);
    }elseif( !empty($_SERVER['HTTP_CLIENT_IP']) AND strlen($_SERVER['HTTP_CLIENT_IP'])>6 ){
         $ip = strip_tags($_SERVER['HTTP_CLIENT_IP']);
    }elseif(!empty($_SERVER['REMOTE_ADDR']) AND strlen($_SERVER['REMOTE_ADDR'])>6){
         $ip = strip_tags($_SERVER['REMOTE_ADDR']);
    }//endif
    if(!$ip) $ip="127.0.0.1";
    return strip_tags($ip);
}


/**
 *  Get Ref Link
 */
function seed_wpnb_ref_link(){
    global $seed_wpnb_post_result;
    $ref_link = '';

    if(!empty($seed_wpnb_post_result['ref'])){
        $ref_url = $_SERVER["HTTP_REFERER"];
        if(!empty($ref_url)){
            $ref_url_parts = parse_url($ref_url);
            $port = '';
            if(!empty($ref_url_parts['port'])){
                $port = ':'.$ref_url_parts['port'];
            }
            if(!empty($ref_url_parts['port'])){
                if($ref_url_parts['port'] == '80'){
                    $port = '';
                }
            }
            $ref_link = $ref_url_parts['scheme'].'://'.$ref_url_parts['host'].$port.$ref_url_parts['path'];
            $ref_link = $ref_link.'?ref='.$seed_wpnb_post_result['ref'];
        }else{

        }
    }else{
        $scheme = 'http';
        if($_SERVER["SERVER_PORT"] == '443'){
            $scheme = 'https';
        }
        $ref_link = $scheme.'://'.$_SERVER["HTTP_HOST"].$_SERVER["REQUEST_URI"];
    }
    return $ref_link;
}

/* Import nag */
//add_action( 'admin_menu', 'seed_wpnb_import_nag' );

function seed_wpnb_import_nag(){
  // cspv4 nag
  if(isset($_GET['action']) && $_GET['action'] == 'seed_wpnb_dismiss_v4_nag'){
    update_option('seed_wpnb_dismiss_v4_nag',true);
  }
  $v4s = get_option('seed_cspv4');
  $v4_nag = get_option('seed_wpnb_dismiss_v4_nag');

  if((isset($_GET['page']) && $_GET['page'] == 'seed_wpnb') && !empty($v4s) && empty($v4_nag)){
    add_settings_error(
        null,
        'seed_wpnb_import_v4',
        'We have detected settings from Version 4, would like to import these settings? Note: This will delete and replace your current page if you have one setup. <a href="'. admin_url() .'options-general.php?page=seed_wpnb_import&v=cspv4">Yes, Import Settings</a> | <a href="'. admin_url() .'options-general.php?page=seed_wpnb&action=seed_wpnb_dismiss_v4_nag">No</a>  ',
        'error'
    );
  }
  // coming-soon nag
  if(isset($_GET['action']) && $_GET['action'] == 'seed_wpnb_dismiss_coming_soon_nag'){
    update_option('seed_wpnb_dismiss_coming_soon_nag',true);
  }
  $coming_soon_s = get_option('seed_csp4_settings_content');
  $coming_soon_nag = get_option('seed_wpnb_dismiss_coming_soon_nag');

  if((isset($_GET['page']) && $_GET['page'] == 'seed_wpnb') && !empty($coming_soon_s) && empty($coming_soon_nag)){

    add_settings_error(
        null,
        'seed_wpnb_import_coming_soon',
        'We have detected settings from our Free Coming Soon and Maintenance Mode Plugin, would like to import these settings? Note: This will delete and replace your current page if you have one setup. <a href="'. admin_url() .'options-general.php?page=seed_wpnb_import&v=coming-soon">Yes, Import Settings</a> | <a href="'. admin_url() .'options-general.php?page=seed_wpnb&action=seed_wpnb_dismiss_coming_soon_nag">No</a>  ',
        'error'
    );
  }
}


/* API nag */
add_action( 'admin_menu', 'seed_wpnb_api_nag' );

function seed_wpnb_api_nag(){
  $api_nag = get_option('seed_wpnb_api_nag');
  if((isset($_GET['page']) && $_GET['page'] == 'seed_wpnb') && !empty($api_nag)){
    add_settings_error(
        null,
        'seed_wpnb_api_nag',
        $api_nag,
        'error'
    );
  }
}

if(seed_wpnb_cu('none')){
  add_action( 'admin_menu', 'seed_wpnb_l_nag' );
}

function seed_wpnb_l_nag(){
  if((isset($_GET['page']) && $_GET['page'] == 'seed_wpnb')){
    add_settings_error(
        null,
        'seed_wpnb_l_nag',
        '<a href="options-general.php?page=seed_wpnb_welcome">Please enter a valid license key.</a>',
        'error'
    );
  }
}


function seed_wpnb_extensions() {

	$extensions = array(
		SEED_WPNB_PLUGIN_PATH.'extentions/mailchimp/mailchimp.php',
        SEED_WPNB_PLUGIN_PATH.'extentions/mailchimp/mailchimp-v3.php',
        SEED_WPNB_PLUGIN_PATH.'extentions/convertkit/convertkit.php',
        SEED_WPNB_PLUGIN_PATH.'extentions/activecampaign/activecampaign.php',
		SEED_WPNB_PLUGIN_PATH.'extentions/database/database.php',
		SEED_WPNB_PLUGIN_PATH.'extentions/sendy/sendy.php',
		SEED_WPNB_PLUGIN_PATH.'extentions/mailpoet/mailpoet.php',
		SEED_WPNB_PLUGIN_PATH.'extentions/madmimi/madmimi.php',
		SEED_WPNB_PLUGIN_PATH.'extentions/infusionsoft/infusionsoft.php',
		SEED_WPNB_PLUGIN_PATH.'extentions/icontact/icontact.php',
		SEED_WPNB_PLUGIN_PATH.'extentions/htmlwebform/htmlwebform.php',
		SEED_WPNB_PLUGIN_PATH.'extentions/gravityforms/gravityforms.php',
		SEED_WPNB_PLUGIN_PATH.'extentions/followupemails/followupemails.php',
		SEED_WPNB_PLUGIN_PATH.'extentions/getresponse/getresponse.php',
		SEED_WPNB_PLUGIN_PATH.'extentions/feedburner/feedburner.php',
		SEED_WPNB_PLUGIN_PATH.'extentions/constantcontact/constantcontact.php',
		SEED_WPNB_PLUGIN_PATH.'extentions/campaignmonitor/campaignmonitor.php',
		SEED_WPNB_PLUGIN_PATH.'extentions/aweber/aweber.php',
        SEED_WPNB_PLUGIN_PATH.'extentions/drip/drip.php',
        SEED_WPNB_PLUGIN_PATH.'extentions/mymail/mymail.php',
        SEED_WPNB_PLUGIN_PATH.'extentions/feedblitz/feedblitz.php',
        SEED_WPNB_PLUGIN_PATH.'extentions/zapier/zapier.php',
	);

	$active_extensions = apply_filters( 'seed_wpnb_active_extensions', $extensions );

	foreach ( $active_extensions as $i ) {
		require_once( $i );
	}

} // END seed_wpnb_extensions()

seed_wpnb_extensions();


function seed_wpnb_select($id,$option_values,$selected = null){
echo "<select id='$id' name='$id' class='form-control input-sm'>";
if(!empty($option_values)){
foreach ( $option_values as $k => $v ) {
	if(is_array($v)){
		echo '<optgroup label="'.ucwords($k).'">';
		foreach ( $v as $k1=>$v1 ) {
			echo '<option value="'.$k1.'"' . selected( $selected , $k1, false ) . ">$v1</option>";
		}
		echo '</optgroup>';
	}else{
			if(!isset($options[ $id ])){
				$options[ $id ] = '';
			}
    		echo "<option value='$k' " . selected( $selected , $k, false ) . ">$v</option>";
	}
}
}
echo "</select> ";
}

