<?php
/**
 * Render Pages
 */

class SEED_WPNB
{

    /**
     * Instance of this class.
     *
     * @since    1.0.0
     *
     * @var      object
     */
    protected static $instance = null;

    private $notificationbar_rendered = false;
    private $path = null;

    function __construct()
    {
        if (!seed_wpnb_cu('none')) {
            add_action( 'wp_head', array(&$this,'render_css') );
        }

        // Deactivate License
        add_action( 'init', array(&$this,'deactivate_license'));
    }

    /**
     * Return an instance of this class.
     */
    public static function get_instance()
    {
        // If the single instance hasn't been set, set it now.
        if (null == self::$instance) {
            self::$instance = new self;
        }

        return self::$instance;
    }

    /**
     *  Deactivate License
     */
    function deactivate_license()
    {
        $token = get_option('seed_wpnb_token');
        $seed_wpnb_api_key = '';
        if (defined('SEED_WPNB_API_KEY')) {
            $seed_wpnb_api_key = SEED_WPNB_API_KEY;
        }
        if (empty($seed_wpnb_api_key)) {
            $seed_wpnb_api_key = get_option('seed_wpnb_license_key');
        }

        if (((isset($_REQUEST['seed_wpnb_token']) && $_REQUEST['seed_wpnb_token'] == $token) || isset($_REQUEST['seed_wpnb_token']) && $_REQUEST['seed_wpnb_token'] == $seed_wpnb_api_key) && (isset($_REQUEST['seed_wpnb_action']) && $_REQUEST['seed_wpnb_action'] == 'deactivate')) {
            $seed_wpnb_per = '';
            if (!empty($_REQUEST['seed_wpnb_per'])) {
                $seed_wpnb_per = $_REQUEST['seed_wpnb_per'];
            }

            $seed_wpnb_api_nag='Site Deactivated';
            if (!empty($_REQUEST['seed_wpnb_api_nag'])) {
                $seed_wpnb_api_nag = $_REQUEST['seed_wpnb_api_nag'];
            }

            update_option('seed_wpnb_api_nag', $seed_wpnb_api_nag);
            update_option('seed_wpnb_api_message', $seed_wpnb_api_nag);
            update_option('seed_wpnb_a', false);
            update_option('seed_wpnb_per', $seed_wpnb_per);
            update_option('seed_wpnb_license_key', '');

            echo 'true';

            exit();
        }
    }

    function render_css($bar_id)
    {
        wp_enqueue_script( 'jquery' );
        require_once(SEED_WPNB_PLUGIN_PATH.'lib/seed_wpnb_lessc.inc.php');
        global $wpdb;
        $tablename = $wpdb->prefix . SEED_WPNB_PAGES_TABLENAME;

        // Page Info
        $page_id = 0;
        if (isset($_GET['seed_wpnb_preview'])) {
            $page_id = $_GET['seed_wpnb_preview'];
        }

        // Get Page all pages
        if (!empty($page_id)) {
            $sql = "SELECT * FROM $tablename WHERE id = $page_id";
            $pages = $wpdb->get_results($sql);
        } else {
            // $tz = get_option('timezone_string');
            // if($tz){
            //     date_default_timezone_set($tz);
            // }
            // var_dump($tz);
            // $now = date( 'Y-m-d H:i:s');
            $sql = "SELECT * FROM $tablename WHERE active IN (1,2)  ORDER BY priority DESC";
            //var_dump($sql);
            $pages = $wpdb->get_results($sql);
        }

        $is_renedered = false;

        foreach ($pages as $k => $v) {
            if ($is_renedered) {
                break;
            }

            $page = $v;

            global $wpnb_page_id;
            $wpnb_page_id = $page->id;

        // Check for base64 encoding of settings
            if (base64_encode(base64_decode($page->settings, true)) === $page->settings) {
                $settings = unserialize(base64_decode($page->settings));
            } else {
                $settings = unserialize($page->settings);
            }

        // Display control

        // see if it is expired
        if(!empty($settings['scheduled_end_date']) && !empty($settings['schedule_timezone'])){
        $date = new DateTime($settings['scheduled_end_date'], new DateTimeZone($settings['schedule_timezone']));
        $expired_timestamp = $date->format('U');
            if( $expired_timestamp <= time()){
                $is_expired = true;
                continue;
            }
        }


        // Check if Preview
            $is_preview = false;
            if ((isset($_GET['seed_wpnb_preview']))) {
                //show_admin_bar( false );
                $is_preview = true;
                // $res = setcookie('wpnb', '', time() - 3600);
                // unset($_COOKIE['wpnb']);
                // var_dump($res);
            }

        // Countdown Launch
            if ($is_preview == false) {
                if (!empty($settings['countdown_date']) && !empty($settings['enable_countdown']) && !empty($settings['countdown_launch'])) {
                    $date = new DateTime($settings['countdown_date'], new DateTimeZone($settings['countdown_timezone']));
                    $timestamp = $date->format('U');
                     // var_dump($timestamp);
                     // var_dump(time());

                    // Launch this biatch
                    if ($timestamp <= time()) {
                        // Email the admin the site has been launched
                        $message = __(sprintf('%s has been launched.', home_url()), 'seedprod');
                        $result = wp_mail( get_option('admin_email'), __(sprintf('%s has been launched.', home_url()), 'seedprod'), $message);

                        $o = get_option('seed_wpnb_settings_content');
                        //var_dump($o);
                        $o['status'] = 0;
                        update_option('seed_wpnb_settings_content', $o);
                        continue;
                    }
                }
            }


            if ($is_preview == false) {
                if (!empty($settings['include_exclude_options']) && $settings['include_exclude_options'] == '2') {
                    if (substr($settings['include_url_pattern'], 0, 3) != '>>>') {
                        // Check for included pages
                        if (!empty($settings['include_url_pattern'])) {
                            //$url = preg_replace('/\?ref=\d*/','',$_SERVER['REQUEST_URI']);
                            // TODO lok for when wordpress is in sub folder
                            $request_uri = explode('?', $_SERVER['REQUEST_URI']);
                            $url = rtrim(ltrim($request_uri[0], '/'), '/');

                            $r = array_intersect(explode('/', $url), explode('/', home_url()));

                            $url = str_replace($r, '', $url);

                            $url = str_replace('/', '', $url);
                            //var_dump($url);

                            $include_urls = explode("\r\n", $settings['include_url_pattern']);
                            $include_urls = array_filter($include_urls);
                            $include_urls = str_replace(home_url(), "", $include_urls);
                            $include_urls = str_replace('/', '', $include_urls);
                            //$include_urls = array_filter($include_urls);
                            if (is_array($include_urls) && in_array($url, $include_urls)) {
                            } else {
                                continue;
                            }
                        }
                    } else {
                        // Check for included pages regex
                        $settings['include_url_pattern'] = substr($settings['include_url_pattern'], 3);
                        if (!empty($settings['include_url_pattern']) && @preg_match("/{$settings['include_url_pattern']}/", $_SERVER['REQUEST_URI']) == 0) {
                            continue;
                        }
                    }
                }

                // Check for excludes pages
                if (!empty($settings['include_exclude_options']) && $settings['include_exclude_options'] == '3') {
                    if (substr($settings['exclude_url_pattern'], 0, 3) != '>>>') {
                        if (!empty($settings['exclude_url_pattern'])) {
                            //$url = preg_replace('/\?ref=\d*/','',$_SERVER['REQUEST_URI']);
                            $request_uri = explode('?', $_SERVER['REQUEST_URI']);
                            $url = rtrim(ltrim($request_uri[0], '/'), '/');

                            $r = array_intersect(explode('/', $url), explode('/', home_url()));

                            $url = str_replace($r, '', $url);

                            $url = str_replace('/', '', $url);
                            //var_dump($url);

                            $exclude_urls = explode("\r\n", $settings['exclude_url_pattern']);
                            $exclude_urls = array_filter($exclude_urls);
                            $exclude_urls = str_replace(home_url(), "", $exclude_urls);
                            $exclude_urls = str_replace('/', '', $exclude_urls);
                            //$exclude_urls = array_filter($exclude_urls);
                            if (is_array($exclude_urls) && in_array($url, $exclude_urls)) {
                                 continue;
                            }
                        }
                    } else {
                        // Check for excluded pages
                        $settings['exclude_url_pattern'] = substr($settings['exclude_url_pattern'], 3);
                        if (!empty($settings['exclude_url_pattern']) && @preg_match("/{$settings['exclude_url_pattern']}/", $_SERVER['REQUEST_URI']) > 0) {
                            continue;
                        }
                    }
                }
            }


        // Only show the Notification Bar on the home page
            if ($is_preview == false) {
                if (!empty($settings['include_exclude_options']) && $settings['include_exclude_options'] == '1'  && !is_front_page() && $is_preview == false) {
                    continue;
                }



                // Only show with url parameter
                if (!empty($settings['include_exclude_options']) && $settings['include_exclude_options'] == '4') {
                    if (!empty($settings['include_exclude_options']) && $settings['include_exclude_options'] == '4'  && isset($_GET[$settings['parameter_name']]) && $is_preview == false) {
                        // just check for parameter name
          
                        if (isset($_GET[$settings['parameter_name']]) && empty($settings['parameter_value'])) {
                        } else {
                            if ($_GET[$settings['parameter_name']] == $settings['parameter_value']) {
                            } else {
                                continue;
                            }
                        }
                    } else {
                        continue;
                    }
                }
            }



            add_action( 'wp_footer', array(&$this,'render_notification_bar'),999 );

            $settings = json_decode(json_encode($settings), false);
            $settings = stripslashes_deep($settings);

            $is_renedered = true;


    ?>
    <?php if (!empty($settings->container_effect_animation)) : ?>
    <!-- Animate CSS -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/3.5.1/animate.min.css">
    <?php endif; ?>
    <?php if (!empty($settings->text_font)) : ?>
    <?php if (strpos($settings->text_font, ",") === false) : ?>
    <link class="gf-text" href='https://fonts.googleapis.com/css?family=<?php echo urlencode(str_replace("'", "", stripslashes($settings->text_font))); ?>:<?php echo $settings->text_weight; ?>&subset=<?php echo $settings->text_subset; ?>' rel='stylesheet' type='text/css'>
    <?php endif; ?>
    <?php endif; ?>
    <?php if (!empty($settings->button_font)) : ?>
    <?php if (strpos($settings->button_font, ",") === false) : ?>
    <link class="gf-button" href='https://fonts.googleapis.com/css?family=<?php echo urlencode(str_replace("'", "", stripslashes($settings->button_font))); ?>:<?php echo $settings->button_weight; ?>&subset=<?php echo $settings->button_subset; ?>' rel='stylesheet' type='text/css'>
    <?php endif; ?>
    <?php endif; ?>
    
    <style>

        #wpnbio-close,#wpnbio-show{
            cursor: pointer;
        }

        #wpnbio-alert ul {
            list-style: none;
        }

        #wpnbio-show{
            color:<?php echo $settings->text_color; ?>;
            display:none;
            <?php if ($settings->bar_position == 'bottom-fixed') { ?>
            bottom:0;
            <?php } else { ?>
            top:0;
            <?php }?>
            position:fixed;
            text-align: center;
            height:32px;
            width:40px;
            z-index:999999;
            right:10px;
            background:<?php echo $settings->background_color ?>;
            <?php if (isset($settings->border_transparent)) { ?>
                border-bottom: 0px solid transparent;
                border-left: 0px solid transparent;
                border-right: 0px solid transparent;
            <?php } else { ?>
                border-bottom: <?php echo $settings->border_width ?>px solid <?php echo $settings->border_color ?>;
                border-left: <?php echo $settings->border_width ?>px solid <?php echo $settings->border_color ?>;
                border-right: <?php echo $settings->border_width ?>px solid <?php echo $settings->border_color ?>;
            <?php } ?>
            -webkit-box-shadow: 0 0px 10px 0px rgba(0, 0, 0, 0.35);
           -moz-box-shadow: 0 0px 10px 0px rgba(0, 0, 0, 0.35);
                    box-shadow: 0 0px 10px 0px rgba(0, 0, 0, 0.35);
        }

        <?php if ($settings->bar_position != 'bottom-fixed') { ?>
        .admin-bar #wpnbio-show{
            top:32px;  
        }
        <?php }?>

        #wpnbio-show img{
            width: 23px;
            display: inline-block;
            margin: 5px auto;
        }

        #wpnb-bar{
            <?php //if(!empty($settings->container_effect_animation)){ ?>
            display:none;
            <?php //} ?>
            <?php if ($settings->bar_position == 'bottom-fixed') { ?>
            position:fixed;
            bottom:0px;
            left:0px;

            <?php } else { ?>
            position:<?php echo $settings->bar_position ?>;
            top:0px;
            left:0px;
            <?php }?>

            width:100%;
            z-index:99999;
            background:<?php echo $settings->background_color ?>;
            text-align:center;
            color:#fff;
            height:auto;
            min-height:33px;
            <?php
            if (isset($settings->border_transparent)) { ?>
                border-bottom: 0px solid transparent;
            <?php                                                                                                                                                                                                                                                                                                                         }else { ?>
                border-bottom: <?php echo $settings->border_width ?>px solid <?php echo $settings->border_color ?>;
            <?php } ?>
            -webkit-box-shadow: 0 0px 10px 0px rgba(0, 0, 0, 0.35);
           -moz-box-shadow: 0 0px 10px 0px rgba(0, 0, 0, 0.35);
                    box-shadow: 0 0px 10px 0px rgba(0, 0, 0, 0.35);
            font-size:14px;
            line-height: 1.5em;
            padding:5px;
            -webkit-box-sizing: border-box;
            -moz-box-sizing: border-box;
              box-sizing: border-box;
        }

        #wpnb-bar a, #wpnb-bar a:link, #wpnb-bar a:active, #wpnb-bar a:visited, #wpnb-bar a:hover{
            text-decoration:none;
        }
        .wpnb-bar-button{
            display:inline-block;
            border-radius: 3px;
            font-weight: bold;
            line-height: initial;
            white-space: nowrap;
            vertical-align: top;
            background-color: #000;
            color:#fff;
            text-transform:none;
            font-size: <?php echo $settings->text_size; ?>px;
            padding: 5px 6px;
            border:none;
        }

        #wpnbio-subscribe-btn{
         cursor:pointer;
        }
        a.wpnb-bar-button{
            vertical-align: baseline;
        }

        #wpnb-bar .form-control{
            height:auto;
            font-size: <?php echo $settings->text_size; ?>px;
            border-radius: 3px;
            width: 175px;
            border:1px solid transparent;
            padding:3px;
            margin: 0;
            display: inline;
        }

        #wpnb-bar label span{
            font-size:9px;
        }



        #wpnbio-description{
        line-height:1.2;
        }

        #wpnbio-wrapper{
            position:relative;
        }

        #wpnbio-close {
            display:none;
            display: block;
            position: absolute;
            top: 0;
            -webkit-box-sizing: initial; 
            -moz-box-sizing: initial;
            box-sizing: initial;
            right: 0;
        }

        #wpnbio-close img{
            width:16px;
        }

        #wpnbio-socialprofiles a{
            color:#fff;
        }

        .wpnbio-section{
            padding-top:4px;
            padding-bottom:4px;
        }-show

        #wpnbio-form{
        margin:0;
        }

        <?php if (!empty($settings->display_inline)) { ?>
        .wpnbio-section{
            display:inline-block;
            margin:0 12px;
        }
        <?php } ?>

        .countdown_section {
            display: inline-block;
            padding: 0 10px;
        }

        /*.countdown_amount {
            padding-right: 4px;
        }*/

        @media (max-width: 480px) {
            #wpnb-bar .form-control{
                display:block;
                margin:auto;
                margin-bottom:3px;
            }
        }

                /* Link Styles */
    <?php if (!empty($settings->button_color)) : ?>
        #wpnb-bar a, #wpnb-bar a:visited, #wpnb-bar a:hover, #wpnb-bar a:active{
            color: <?php echo $settings->button_color; ?>;
        }

        <?php
        $css = "
          .buttonBackground(@startColor, @endColor) {
          .gradientBar(@startColor, @endColor);
          *background-color: @endColor; /* Darken IE7 buttons by default so they stand out more given they won't have borders */
          .reset-filter();
          &:hover, &:active, &.active, &.disabled, &[disabled] {
            background-color: @endColor;
            *background-color: darken(@endColor, 5%);
          }
          // IE 7 + 8 can't handle box-shadow to show active, so we darken a bit ourselves
          &:active,
          &.active {
            background-color: darken(@endColor, 10%) e(\"\9\");
          }
        }
        .reset-filter() {
          filter: e(%(\"progid:DXImageTransform.Microsoft.gradient(enabled = false)\"));
        }
        .gradientBar(@primaryColor, @secondaryColor) {
          #gradient > .vertical(@primaryColor, @secondaryColor);
          border-color: @secondaryColor @secondaryColor darken(@secondaryColor, 15%);
          border-color: rgba(0,0,0,.1) rgba(0,0,0,.1) fadein(rgba(0,0,0,.1), 15%);
        }
        #gradient {
            .vertical(@startColor: #555, @endColor: #333) {
            background-color: @startColor;
            background-image: -moz-linear-gradient(top, @startColor, @endColor); // FF 3.6+
            background-image: -ms-linear-gradient(top, @startColor, @endColor); // IE10
            background-image: -webkit-gradient(linear, 0 0, 0 100%, from(@startColor), to(@endColor)); // Safari 4+, Chrome 2+
            background-image: -webkit-linear-gradient(top, @startColor, @endColor); // Safari 5.1+, Chrome 10+
            background-image: -o-linear-gradient(top, @startColor, @endColor); // Opera 11.10
            background-image: linear-gradient(top, @startColor, @endColor); // The standard
            background-repeat: repeat-x;
            filter: e(%(\"progid:DXImageTransform.Microsoft.gradient(startColorstr='%d', endColorstr='%d', GradientType=0)\",@startColor,@endColor)); // IE9 and down
          }
        }
        .lightordark (@c) when (lightness(@c) >= 65%) {
            color: black;
            text-shadow: 0 -1px 0 rgba(256, 256, 256, 0.3);
        }
        .lightordark (@c) when (lightness(@c) < 65%) {
            color: white;
            text-shadow: 0 -1px 0 rgba(0, 0, 0, 0.3);
        }
        @btnColor: {$settings->button_color};
        @btnDarkColor: darken(@btnColor, 15%);

        .wpnb-bar-button, #wpnb-bar a.wpnb-bar-button{
          .lightordark (@btnColor);
          .buttonBackground(@btnColor, @btnDarkColor);
        }

        .wpnb-bar-button:hover, #wpnb-bar a.wpnb-bar-button:hover{
            .lightordark (@btnColor);
            .buttonBackground(@btnColor, @btnDarkColor);
        }

        @inputBackgroundColor: {$settings->form_color};
        #wpnb-bar .form-control{
            background-color:@inputBackgroundColor;
        }
        // Change form color input based on light or dark
        #wpnb-bar .form-control{
            .lightordark (@inputBackgroundColor);
        }

        ";
        try {
            $less = new seed_wpnb_lessc();
            $style = $less->parse($css);
            echo $style;
        } catch (Exception $e) {
            echo $e;
        }
        ?>
    <?php endif; ?>

    <?php if (empty($settings->container_flat)) : ?>
    <?php
        $css = "
        @primaryColor: {$settings->button_color};
        .wpnb-bar-button, #wpnb-bar a.wpnb-bar-button,.wpnb-bar-button:hover,#wpnb-bar a.wpnb-bar-button:hover{
            background-image:none;
            text-shadow:none;
        }


        ";
        $less = new seed_wpnb_lessc();
        $style = $less->parse($css);
        echo $style;
        ?>
    <?php endif; ?>

    /* Text Styles */
    <?php if (!empty($settings->text_font)) : ?>
        #wpnb-bar{
            font-family: <?php echo $settings->text_font; ?>;
            font-weight: <?php echo preg_replace('/[a-zA-Z]/', '', $settings->text_weight); ?>;
            font-style: <?php echo preg_replace('/[0-9]/', '', $settings->text_weight); ?>;
            font-size: <?php echo $settings->text_size; ?>px;
            line-height: 0;
            <?php if (!empty($settings->text_color)) : ?>
            color:<?php echo $settings->text_color; ?>;
            <?php endif; ?>
        }

        ::-webkit-input-placeholder {
            font-family:<?php echo $settings->text_font; ?>;
            font-weight: <?php echo preg_replace('/[a-zA-Z]/', '', $settings->text_weight); ?>;
            font-style: <?php echo preg_replace('/[0-9]/', '', $settings->text_weight); ?>;
        }
        ::-moz-placeholder {
            font-family:<?php echo $settings->text_font; ?>;
            font-weight: <?php echo preg_replace('/[a-zA-Z]/', '', $settings->text_weight); ?>;
            font-style: <?php echo preg_replace('/[0-9]/', '', $settings->text_weight); ?>;
        } /* firefox 19+ */
        :-ms-input-placeholder {
            font-family:<?php echo $settings->text_font; ?>;
            font-weight: <?php echo preg_replace('/[a-zA-Z]/', '', $settings->text_weight); ?>;
            font-style: <?php echo preg_replace('/[0-9]/', '', $settings->text_weight); ?>;
        } /* ie */
        :-moz-placeholder {
            font-family:<?php echo $settings->text_font; ?>;
            font-weight: <?php echo preg_replace('/[a-zA-Z]/', '', $settings->text_weight); ?>;
            font-style: <?php echo preg_replace('/[0-9]/', '', $settings->text_weight); ?>;
        }

    <?php endif; ?>

        #wpnb-bar{
            font-size: <?php echo $settings->text_size; ?>px;
            line-height: 0;
            <?php if (!empty($settings->text_color)) : ?>
            color:<?php echo $settings->text_color; ?>;
            <?php endif; ?>
        }

        #wpnbio-countdown{
            line-height: 1.2;
        }



        #wpnbio-socialprofiles a{
            <?php if (!empty($settings->text_color)) : ?>
            color:<?php echo $settings->text_color; ?> !important;
            <?php endif; ?>
        }
    <?php if (!empty($settings->button_font)) : ?>
        .wpnb-bar-button{
            font-family: <?php echo $settings->button_font; ?>;
            font-weight: <?php echo preg_replace('/[a-zA-Z]/', '', $settings->button_weight); ?>;
            font-style: <?php echo preg_replace('/[0-9]/', '', $settings->button_weight); ?>;
        }
    <?php else : ?>
        .wpnb-bar-button{
            <?php if (!empty($settings->text_font)) : ?>
            font-family: <?php echo $settings->text_font; ?>;
            <?php endif; ?>
            font-weight: <?php echo preg_replace('/[a-zA-Z]/', '', $settings->text_weight); ?>;
            font-style: <?php echo preg_replace('/[0-9]/', '', $settings->text_weight); ?>;
        }
    <?php endif; ?>
    <?php if (!empty($settings->custom_css)) : ?>
    <?php echo $settings->custom_css; ?>
    <?php endif; ?>
    </style>
    <?php
        }
    }


    /**
     * Display the notification bar
     */
    function render_notification_bar()
    {

        // Page Info
        global $wpnb_page_id;
        $page_id = $wpnb_page_id;



        // Get Page
        global $wpdb;
        $tablename = $wpdb->prefix . SEED_WPNB_PAGES_TABLENAME;
        $sql = "SELECT * FROM $tablename WHERE id= %d";
        $safe_sql = $wpdb->prepare($sql, $page_id);
        $page = $wpdb->get_row($safe_sql);

        // Check for base64 encoding of settings
        if (base64_encode(base64_decode($page->settings, true)) === $page->settings) {
            $settings = unserialize(base64_decode($page->settings));
        } else {
            $settings = unserialize($page->settings);
        }


        // Finally check if we should show the coming soon page.
        $this->notificationbar_rendered = true;


        if (empty($settings)) {
            echo __( "Please create your Notification Bar in the plugin settings.", "seedprod-wp-notification-bar-pro" );
            exit();
        }
        


        // render
        if (!empty($page->html)) {
            echo $page->html;
        } else {
            include(SEED_WPNB_PLUGIN_PATH.'template/index.php');
        }
    }
}
