<?php
/*
Plugin Name: SeedProd Login Page Pro
Plugin URI: https://www.seedprod.com
Description: The Login Page Customizer Plugin
Version:  1.1.15
Author: SeedProd
Author URI: http://www.seedprod.com
TextDomain: seedprod-login-page-pro
Domain Path: /languages
License: PHP Licensed under the GPLv2, Javascript and CSS are Proprietary and can not be redistributed without consent of copyright holder.
Copyright 2016 SeedProd LLC (email : john@seedprod.com, twitter : @seedprod)
*/

/**
 * Default Constants
 */
define('SEED_CLP_SHORTNAME', 'seed_clp'); // Used to reference namespace functions.
define('SEED_CLP_SLUG', 'seedprod-login-page-pro/seedprod-login-page-pro.php'); // Used for settings link.
define('SEED_CLP_TEXTDOMAIN', 'seedprod-login-page-pro'); // Your textdomain
define('SEED_CLP_PLUGIN_NAME', __('Login Page Pro', 'seedprod-login-page-pro')); // Plugin Name shows up on the admin settings screen.
define('SEED_CLP_VERSION', '1.1.15'); // Plugin Version Number.
define('SEED_CLP_PLUGIN_PATH', plugin_dir_path(__FILE__)); // Example output: /Applications/MAMP/htdocs/wordpress/wp-content/plugins/seed_clp/
define('SEED_CLP_PLUGIN_URL', plugin_dir_url(__FILE__)); // Example output: http://localhost:8888/wordpress/wp-content/plugins/seed_clp/
define('SEED_CLP_API_URL', 'https://api.seedprod.com/v2/update');

/**
 * Load Translation
 */
function seed_clp_load_textdomain()
{
    load_plugin_textdomain('seedprod-login-page-pro', false, dirname(plugin_basename(__FILE__)) . '/languages/');
}
add_action('plugins_loaded', 'seed_clp_load_textdomain');


/**
 * Upon activation of the plugin set defaults
 */
function seed_clp_activation()
{
    require_once(SEED_CLP_PLUGIN_PATH.'admin/default-settings.php');
    $seed_clp_settings_defaults = array(
    'seed_clp_settings_content' => 'a:1:{s:6:"status";s:1:"0";}',
  );


    $seed_clp_customizer_defaults = array(
    'disabled_fields' => '',
    'first_run' => '',
    'page_id' => '1',
    'logo_height' => '',
    'logo_width' => '',
    'logo' => '',
    'description' => '',
    'rich_description' => '',
    'background_color' => '#f1f1f1',
    'background_image' => '',
    'enable_background_adv_settings' => '1',
    'background_overlay' => '',
    'background_size' => 'cover',
    'background_repeat' => 'no-repeat',
    'background_position' => 'center top',
    'background_attachment' => 'fixed',
    'bg_slideshow_images' =>
    array(
      0 => '',
    ),
    'bg_slideshow_slide_speed' => '0',
    'bg_video_url' => '',
    'container_color' => '#ffffff',
    'container_radius' => '0',
    'container_position' => '0',
    'container_width' => '319',
    'container_effect_animation' => '',
    'text_color' => '#72777c',
    'button_color' => '',
    'form_color' => '',
    'text_link_color' => '',
    'text_font' => "Open Sans'",
    'text_weight' => '400',
    'text_subset' => '',
    'text_size' => '14',
    'text_line_height' => '1.50',
    'theme_css' => '',
    'theme_scripts' => '',
    'custom_css' => '',
    'social_profiles_size' => '',
    'social_profiles_blank' => '1',
    'recaptcha_site_key' => '',
    'recaptcha_secret_key' => '',
    'import_settings' => '',
    'check_mic' => 'sibilance',
  );

    add_option('seed_clp_customizer_settings', $seed_clp_customizer_defaults);
    add_option('seed_clp_settings_content', serialize($seed_clp_settings_defaults));
}
register_activation_hook(__FILE__, 'seed_clp_activation');

if (!empty($_GET['seed_clp_force_db_setup'])) {
    seed_clp_activation();
}



/***************************************************************************
 * Load Required Files
 ***************************************************************************/
// Global Settings Var
global $seed_clp_settings;

require_once(SEED_CLP_PLUGIN_PATH.'admin/get-settings.php');
$seed_clp_settings = seed_clp_get_settings();

// Class to render pages
require_once(SEED_CLP_PLUGIN_PATH.'inc/class-seed-clp.php');
add_action('plugins_loaded', array( 'SEED_CLP', 'get_instance' ));


if (is_admin()) {
    // Admin Only
    require_once(SEED_CLP_PLUGIN_PATH.'admin/config-settings.php');
    require_once(SEED_CLP_PLUGIN_PATH.'admin/admin.php');
    // Load Admin
    add_action('plugins_loaded', array( 'SEED_CLP_ADMIN', 'get_instance' ));
} else {
    // Public only
}

// Welcome Page

register_activation_hook(__FILE__, 'seed_clp_welcome_screen_activate');
function seed_clp_welcome_screen_activate()
{
    set_transient('_seed_clp_welcome_screen_activation_redirect', true, 30);
    add_option('seed_clp_token', strtolower(wp_generate_password(32, false, false)));
}



add_action('admin_init', 'seed_clp_welcome_screen_do_activation_redirect');
function seed_clp_welcome_screen_do_activation_redirect()
{
    // Bail if no activation redirect
    if (! get_transient('_seed_clp_welcome_screen_activation_redirect')) {
        return;
    }

    // Delete the redirect transient
    delete_transient('_seed_clp_welcome_screen_activation_redirect');

    // Bail if activating from network, or bulk
    if (is_network_admin() || isset($_GET['activate-multi'])) {
        return;
    }

    // Redirect to bbPress about page
    wp_safe_redirect(add_query_arg(array( 'page' => 'seed_clp_welcome' ), admin_url('index.php')));
}

add_action('admin_menu', 'seed_clp_welcome_screen_pages');

function seed_clp_welcome_screen_pages()
{
    add_dashboard_page(
    'Welcome To Welcome Screen',
    'Welcome To Welcome Screen',
    'read',
    'seed_clp_welcome',
    'seed_clp_welcome_screen_content'
  );
}

function seed_clp_welcome_screen_content()
{
    require_once(SEED_CLP_PLUGIN_PATH.'admin/license.php');
}
add_action('admin_head', 'seed_clp_welcome_screen_remove_menus');
function seed_clp_welcome_screen_remove_menus()
{
    remove_submenu_page('index.php', 'seed_clp_welcome');
}

/**
 * SeedProd Functions
 */
require_once(SEED_CLP_PLUGIN_PATH.'inc/functions.php');

// Api Updates

/**
* API Updates
*/

if (!class_exists('SeedProd_Updater_clp')) {
    // load our custom updater
    include(dirname(__FILE__) . '/seedprod-updater-clp.php');
}
function seed_clp_plugin_updater()
{
    $seed_clp_api_key = '';
    $seed_emaillist = "";
    $seed_admin_email = get_option('admin_email', '');
    if (defined('SEED_CSP_API_KEY')) {
        $seed_clpv4_api_key = SEED_CSP_API_KEY;
    }
    if (empty($seed_clp_api_key)) {
        $seed_clp_api_key = get_option('seed_clp_license_key');
    }
    if (!empty($seed_clpv4['emaillist'])) {
        $seed_emaillist = $seed_clpv4['emaillist'];
    }
    $data = array();
    $data['emaillist'] = $seed_emaillist;
    $data['admin_email'] = $seed_admin_email;
    // retrieve our license key from the DB
    //$license_key = trim( get_option( 'edd_sample_license_key' ) );
    // setup the updater

    $seedprod_updater = new SeedProd_Updater_clp(
        SEED_CLP_API_URL,
        __FILE__,
        array(
            'license'   => $seed_clp_api_key,        // license key (used get_option above to retrieve from DB)
            'data'      => $data
        )
    );
}
add_action('admin_init', 'seed_clp_plugin_updater', 0);


add_action('admin_head', 'seed_clp_set_user_settings');
function seed_clp_set_user_settings()
{
    if (isset($_GET['page']) && $_GET['page'] == 'seed_clp') {
        $user_id = get_current_user_id();
        $options = get_user_option('user-settings', $user_id);
        parse_str($options, $user_settings);
        $user_settings['imgsize'] = 'full';
        update_user_option($user_id, 'user-settings', http_build_query($user_settings), false);
        update_user_option($user_id, 'user-settings-time', time(), false);
    }
}


//Remove login page filters
if (!empty($_GET['seed_clp_preview'])) {
    remove_all_filters('login_init');

    function wp_authenticate($username, $password)
    {
        $user = new WP_Error();
        return $user;
    }
}