<?php
/*
Plugin Name: SeedProd Countdown Pro
Plugin URI: https://www.seedprod.com
Description: The Ultimate Countdown Plugin
Version:  1.0.7
Author: SeedProd
Author URI: http://www.seedprod.com
TextDomain: seedprod-countdown-pro
Domain Path: /languages
License: PHP Licensed under the GPLv2, Javascript and CSS are Proprietary and can not be redistributed without consent of copyright
Copyright 2017 SeedProd LLC (email : john@seedprod.com, twitter : @seedprod)
*/

/**
 * Default Constants
 */
define( 'SEED_CDP_SHORTNAME', 'seed_cdp' ); // Used to reference namespace functions.
define( 'SEED_CDP_SLUG', 'seedprod-countdown-pro/seedprod-countdown-pro.php' ); // Used for settings link.
define( 'SEED_CDP_TEXTDOMAIN', 'seedprod-countdown-pro' ); // Your textdomain
define( 'SEED_CDP_PLUGIN_NAME', __( 'Countdown Pro', 'seedprod-countdown-pro' ) ); // Plugin Name shows up on the admin settings screen.
define( 'SEED_CDP_VERSION', '1.0.7'); // Plugin Version Number.
define( 'SEED_CDP_PLUGIN_PATH', plugin_dir_path( __FILE__ ) ); // Example output: /Applications/MAMP/htdocs/wordpress/wp-content/plugins/seed_cdp/
define( 'SEED_CDP_PLUGIN_URL', plugin_dir_url( __FILE__ ) ); // Example output: http://localhost:8888/wordpress/wp-content/plugins/seed_cdp/
define( 'SEED_CDP_SUBSCRIBERS_TABLENAME', 'cdp_subscribers' );
define( 'SEED_CDP_PAGES_TABLENAME', 'cdp_countdowns' );
define( 'SEED_CDP_THEME_API_URL', '');
define( 'SEED_CDP_API_URL', 'https://api.seedprod.com/v2/update' );


/**
 * Load Translation
 */
function seed_cdp_load_textdomain() {
    load_plugin_textdomain( 'seedprod-countdown-pro', false, dirname( plugin_basename( __FILE__ ) ) . '/languages/' );
}
add_action('plugins_loaded', 'seed_cdp_load_textdomain');


/**
 * Upon activation of the plugin set defaults
 */
function seed_cdp_activation(){
  global $seed_cdp_settings_defaults;
  require_once( SEED_CDP_PLUGIN_PATH.'admin/default-settings.php' );

  add_option('seed_cdp_settings_content',unserialize($seed_cdp_settings_defaults['seed_cdp_settings_content']));

  add_option('seed_cdp_token',strtolower(wp_generate_password(32,false, false)));

}
register_activation_hook( __FILE__, 'seed_cdp_activation' );



/***************************************************************************
 * Load Required Files
 ***************************************************************************/
// Global Settings Var
global $seed_cdp_settings;

require_once( SEED_CDP_PLUGIN_PATH.'admin/get-settings.php' );
$seed_cdp_settings = seed_cdp_get_settings();

// Class to render countdowns
require_once( SEED_CDP_PLUGIN_PATH.'inc/class-seed-cdp.php' );
add_action( 'plugins_loaded', array( 'SEED_CDP', 'get_instance' ) );


if( is_admin() ) {
	// Admin Only
	require_once( SEED_CDP_PLUGIN_PATH.'admin/config-settings.php' );
    require_once( SEED_CDP_PLUGIN_PATH.'admin/admin.php' );
    // Load Admin
    add_action( 'plugins_loaded', array( 'SEED_CDP_ADMIN', 'get_instance' ) );
} else {
	// Public only
}

// Welcome Page
if(!defined('SEED_CSP_API_KEY')){
  register_activation_hook( __FILE__, 'seed_cdp_welcome_screen_activate' );
}
function seed_cdp_welcome_screen_activate() {
  set_transient( '_seed_cdp_welcome_screen_activation_redirect', true, 30 );
}


if(!defined('SEED_CSP_API_KEY')){
  add_action( 'admin_init', 'seed_cdp_welcome_screen_do_activation_redirect' );
}
function seed_cdp_welcome_screen_do_activation_redirect() {
  // Bail if no activation redirect
    if ( ! get_transient( '_seed_cdp_welcome_screen_activation_redirect' ) ) {
    return;
  }

  // Delete the redirect transient
  delete_transient( '_seed_cdp_welcome_screen_activation_redirect' );

  // Bail if activating from network, or bulk
  if ( is_network_admin() || isset( $_GET['activate-multi'] ) ) {
    return;
  }

  // Redirect to bbPress about page
  wp_safe_redirect( add_query_arg( array( 'page' => 'seed_cdp_welcome' ), admin_url( 'options-general.php' ) ) );
}

if(!defined('SEED_CSP_API_KEY')){
  add_action('admin_menu', 'seed_cdp_welcome_screen_pages');
}

function seed_cdp_welcome_screen_pages() {
  add_options_page(
    'Welcome To SeedProd',
    'Welcome To SeedProd',
    'read',
    'seed_cdp_welcome',
    'seed_cdp_welcome_screen_content'
  );
}

function seed_cdp_welcome_screen_content() {
  require_once(SEED_CDP_PLUGIN_PATH.'admin/license.php');
}
add_action( 'admin_head', 'seed_cdp_welcome_screen_remove_menus' );
function seed_cdp_welcome_screen_remove_menus() {
    remove_submenu_page( 'options-general.php', 'seed_cdp_welcome' );
}

/**
 * SeedProd Functions
 */
require_once(SEED_CDP_PLUGIN_PATH.'inc/functions.php');


/**
* API Updates
*/

if( !class_exists( 'SeedProd_Updater_cdp' ) ) {
    // load our custom updater
    include( dirname( __FILE__ ) . '/seedprod-updater-cdp.php' );
}
function seed_cdp_plugin_updater() {

    $seed_cdp_api_key = '';
    $seed_emaillist = "";
    $seed_admin_email = get_option( 'admin_email','' );
    if(defined('SEED_CSP_API_KEY')){
        $seed_cdp_api_key = SEED_CSP_API_KEY;
    }
    if(empty($seed_cdp_api_key)){
        $seed_cdp_api_key = get_option('seed_cdp_license_key');
    }

    $data = array();
    $data['emaillist'] = $seed_emaillist;
    $data['admin_email'] = $seed_admin_email;
    // retrieve our license key from the DB
    //$license_key = trim( get_option( 'edd_sample_license_key' ) );
    // setup the updater

    $seedprod_updater = new SeedProd_Updater_cdp( SEED_CDP_API_URL, __FILE__, array(
            'license'   => $seed_cdp_api_key,        // license key (used get_option above to retrieve from DB)
            'data'      => $data
        )
    );

}
add_action( 'admin_init', 'seed_cdp_plugin_updater', 0 );




add_action( 'admin_head', 'seed_cdp_set_user_settings' );
function seed_cdp_set_user_settings() {
  if(isset($_GET['page']) && $_GET['page'] == 'seed_cdp'){
              $user_id = get_current_user_id();
              $options = get_user_option( 'user-settings', $user_id );
              parse_str($options,$user_settings);
              $user_settings['imgsize'] = 'full';
              update_user_option( $user_id, 'user-settings', http_build_query($user_settings), false );
              update_user_option( $user_id, 'user-settings-time', time(), false );
  }
}



// Multisite Initial Install License Check
function seed_cdp_check_license_updater(){
    if(get_option('seed_cdp_a') === false){
    add_option('seed_cdp_license_key',SEED_CSP_API_KEY);
    add_option('seed_cdp_token',strtolower(wp_generate_password(32,false, false)));

    $params = array(
        'action'     => 'info',
        'license_key'=> SEED_CSP_API_KEY,
        'slug'       => SEED_CDP_SLUG,
        'domain'        => home_url(),
        'installed_version' => SEED_CDP_VERSION,
        'token'      => get_option('seed_cdp_token'),
    );
    $request = wp_remote_post( SEED_CDP_API_URL, array( 'timeout' => 15, 'sslverify' => false, 'body' => $params ) );
    if ( ! is_wp_error( $request ) ) {
                $request = wp_remote_retrieve_body( $request );
                $arequest = json_decode($request);
                $nag = $arequest->message;

                update_option('seed_cdp_license_key',$api_key);
                
                update_option('seed_cdp_api_message',$nag);
                if($arequest->status == '200'){
                    update_option('seed_cdp_api_nag','');
                    update_option('seed_cdp_a',true);
                    update_option('seed_cdp_per',$arequest->per);
                }elseif($arequest->status == '401'){
                    update_option('seed_cdp_api_nag',$nag);
                    update_option('seed_cdp_a',false);
                    update_option('seed_cdp_per','');
                }elseif($arequest->status == '402'){
                    update_option('seed_cdp_api_nag',$nag);
                    update_option('seed_cdp_a',false);
                    update_option('seed_cdp_per',$arequest->per);

                }     


            }
    }
}

if(defined('SEED_CSP_API_KEY')){
  if(isset($_GET['page']) && $_GET['page'] == 'seed_cdp'){
    add_action( 'admin_init', 'seed_cdp_check_license_updater');
  }
}

// allow shortcode in widgets
add_filter('widget_text','do_shortcode');

