<?php
/*
Plugin Name: SeedProd 404 Page Pro
Plugin URI: https://www.seedprod.com
Description: The Ultimate 404 Page Plugin
Version:  2.0.10
Author: SeedProd
Author URI: http://www.seedprod.com
TextDomain: seedprod-404-page-pro
Domain Path: /languages
License: PHP Licensed under the GPLv2, Javascript and CSS are Proprietary and can not be redistributed without consent of copyright holder.
Copyright 2016 SeedProd LLC (email : john@seedprod.com, twitter : @seedprod)
*/

/**
 * Default Constants
 */
define( 'SEED_S404P_SHORTNAME', 'seed_s404p' ); // Used to reference namespace functions.
define( 'SEED_S404P_SLUG', 'seedprod-404-page-pro/seedprod-404-page-pro.php' ); // Used for settings link.
define( 'SEED_S404P_TEXTDOMAIN', 'seedprod-404-page-pro' ); // Your textdomain
define( 'SEED_S404P_PLUGIN_NAME', __( '404 Page Pro', 'seedprod-404-page-pro' ) ); // Plugin Name shows up on the admin settings screen.
define( 'SEED_S404P_VERSION', '2.0.10'); // Plugin Version Number.
define( 'SEED_S404P_PLUGIN_PATH', plugin_dir_path( __FILE__ ) ); // Example output: /Applications/MAMP/htdocs/wordpress/wp-content/plugins/seed_s404p/
define( 'SEED_S404P_PLUGIN_URL', plugin_dir_url( __FILE__ ) ); // Example output: http://localhost:8888/wordpress/wp-content/plugins/seed_s404p/
define( 'SEED_S404P_SUBSCRIBERS_TABLENAME', 's404p_subscribers' );
define( 'SEED_S404P_PAGES_TABLENAME', 's404p_pages' );

define( 'SEED_S404P_THEME_BASE_URL', 'https://s3.amazonaws.com/static.seedprod.com/themes/' );
define( 'SEED_S404P_API_URL', 'http://api.sellwp.co/v2/update' );
define( 'SEED_S404P_THEME_API_URL', '' );
define( 'SEED_S404P_BACKGROUND_API_URL', 'http://api.sellwp.co/v3/backgrounds' );




/**
 * Load Translation
 */
function seed_s404p_load_textdomain() {
    load_plugin_textdomain( 'seedprod-404-page-pro', false, dirname( plugin_basename( __FILE__ ) ) . '/languages/' );
}
add_action('plugins_loaded', 'seed_s404p_load_textdomain');


/**
 * Upon activation of the plugin set defaults
 */
function seed_s404p_activation(){
  global $seed_s404p_settings_defaults;
  require_once( SEED_S404P_PLUGIN_PATH.'admin/default-settings.php' );

  add_option('seed_s404p_settings_content',unserialize($seed_s404p_settings_defaults['seed_s404p_settings_content']));

  // Disable mojo coming soon
  if(get_option( 'mm_coming_soon' ) === 'true'){
    update_option( 'mm_coming_soon', 'false' );
  }

  add_option('seed_s404p_token',strtolower(wp_generate_password(32,false, false)));


  // seed_s404p_add_rules();
  // flush_rewrite_rules();
}
register_activation_hook( __FILE__, 'seed_s404p_activation' );


/**
 * Upon deactivation of the plugin
 */
function seed_s404p_deactivation(){
  flush_rewrite_rules();
}
//register_deactivation_hook( __FILE__, 'seed_s404p_deactivation' );


//add_action('init','seed_s404p_add_rules');
function seed_s404p_add_rules(){
  add_rewrite_rule('stores/?([^/]*)','index.php?pagename=stores&store_id=$matches[1]','top');
}

//add_filter('query_vars','seed_s404p_add_query_var');
function seed_s404p_add_query_var($vars){
  $vars[] = 'store_id';
  return $vars;

}




/***************************************************************************
 * Load Required Files
 ***************************************************************************/
// Global Settings Var
global $seed_s404p_settings;

require_once( SEED_S404P_PLUGIN_PATH.'admin/get-settings.php' );
$seed_s404p_settings = seed_s404p_get_settings();

// Class to render pages
require_once( SEED_S404P_PLUGIN_PATH.'inc/class-seed-s404p.php' );
add_action( 'plugins_loaded', array( 'SEED_S404P', 'get_instance' ) );


if( is_admin() ) {
	// Admin Only
	require_once( SEED_S404P_PLUGIN_PATH.'admin/config-settings.php' );
    require_once( SEED_S404P_PLUGIN_PATH.'admin/admin.php' );
    // Load Admin
    add_action( 'plugins_loaded', array( 'SEED_S404P_ADMIN', 'get_instance' ) );
} else {
	// Public only
}

// Welcome Page
if(!defined('SEED_S404P_API_KEY')){
  register_activation_hook( __FILE__, 'seed_s404p_welcome_screen_activate' );
}
function seed_s404p_welcome_screen_activate() {
  set_transient( '_seed_s404p_welcome_screen_activation_redirect', true, 30 );
}


if(!defined('SEED_S404P_API_KEY')){
  add_action( 'admin_init', 'seed_s404p_welcome_screen_do_activation_redirect' );
}
function seed_s404p_welcome_screen_do_activation_redirect() {
  // Bail if no activation redirect
    if ( ! get_transient( '_seed_s404p_welcome_screen_activation_redirect' ) ) {
    return;
  }

  // Delete the redirect transient
  delete_transient( '_seed_s404p_welcome_screen_activation_redirect' );

  // Bail if activating from network, or bulk
  if ( is_network_admin() || isset( $_GET['activate-multi'] ) ) {
    return;
  }

  // Redirect to bbPress about page
  wp_safe_redirect( add_query_arg( array( 'page' => 'seed_s404p_welcome' ), admin_url( 'options-general.php' ) ) );
}

if(!defined('SEED_S404P_API_KEY')){
  add_action('admin_menu', 'seed_s404p_welcome_screen_pages');
}

function seed_s404p_welcome_screen_pages() {
  add_options_page(
    'Welcome To SeedProd',
    'Welcome To SeedProd',
    'read',
    'seed_s404p_welcome',
    'seed_s404p_welcome_screen_content'
  );
}

function seed_s404p_welcome_screen_content() {
  require_once(SEED_S404P_PLUGIN_PATH.'admin/license.php');
}
add_action( 'admin_head', 'seed_s404p_welcome_screen_remove_menus' );
function seed_s404p_welcome_screen_remove_menus() {
    remove_submenu_page( 'options-general.php', 'seed_s404p_welcome' );
}

/**
 * SeedProd Functions
 */
require_once(SEED_S404P_PLUGIN_PATH.'inc/functions.php');


// Api Updates

/**
* API Updates
*/

if( !class_exists( 'SeedProd_Updater_s404p' ) ) {
    // load our custom updater
    include( dirname( __FILE__ ) . '/seedprod-updater-s404p.php' );
}
function seed_s404p_plugin_updater() {

    $seed_s404p_api_key = '';
    $seed_emaillist = "";
    $seed_admin_email = get_option( 'admin_email','' );
    if(defined('SEED_S404P_API_KEY')){
        $seed_s404p_api_key = SEED_S404P_API_KEY;
    }
    if(empty($seed_s404p_api_key)){
        $seed_s404p_api_key = get_option('seed_s404p_license_key');
    }
    if(!empty($seed_cspv4['emaillist'])){
        $seed_emaillist = $seed_cspv4['emaillist'];
    }
    $data = array();
    $data['emaillist'] = $seed_emaillist;
    $data['admin_email'] = $seed_admin_email;
    // retrieve our license key from the DB
    //$license_key = trim( get_option( 'edd_sample_license_key' ) );
    // setup the updater

    $seedprod_updater = new SeedProd_Updater_s404p( SEED_S404P_API_URL, __FILE__, array(
            'license'   => $seed_s404p_api_key,        // license key (used get_option above to retrieve from DB)
            'data'      => $data
        )
    );

}
add_action( 'admin_init', 'seed_s404p_plugin_updater', 0 );




add_action( 'admin_head', 'seed_s404p_set_user_settings' );
function seed_s404p_set_user_settings() {
  if(isset($_GET['page']) && $_GET['page'] == 'seed_s404p'){
              $user_id = get_current_user_id();
              $options = get_user_option( 'user-settings', $user_id );
              parse_str($options,$user_settings);
              $user_settings['imgsize'] = 'full';
              update_user_option( $user_id, 'user-settings', http_build_query($user_settings), false );
              update_user_option( $user_id, 'user-settings-time', time(), false );
  }
}



// Multisite Initial Install License Check
function seed_s404p_check_license_updater(){
    if(get_option('seed_s404p_a') === false){
    add_option('seed_s404p_license_key',SEED_S404P_API_KEY);
    add_option('seed_s404p_token',strtolower(wp_generate_password(32,false, false)));

    $params = array(
        'action'     => 'info',
        'license_key'=> SEED_S404P_API_KEY,
        'slug'       => SEED_S404P_SLUG,
        'domain'        => home_url(),
        'installed_version' => SEED_S404P_VERSION,
        'token'      => get_option('seed_s404p_token'),
    );
    $request = wp_remote_post( SEED_S404P_API_URL, array( 'timeout' => 15, 'sslverify' => false, 'body' => $params ) );
    if ( ! is_wp_error( $request ) ) {
                $request = wp_remote_retrieve_body( $request );
                $arequest = json_decode($request);
                $nag = $arequest->message;

                update_option('seed_s404p_license_key',$api_key);
                
                update_option('seed_s404p_api_message',$nag);
                if($arequest->status == '200'){
                    update_option('seed_s404p_api_nag','');
                    update_option('seed_s404p_a',true);
                    update_option('seed_s404p_per',$arequest->per);
                }elseif($arequest->status == '401'){
                    update_option('seed_s404p_api_nag',$nag);
                    update_option('seed_s404p_a',false);
                    update_option('seed_s404p_per','');
                }elseif($arequest->status == '402'){
                    update_option('seed_s404p_api_nag',$nag);
                    update_option('seed_s404p_a',false);
                    update_option('seed_s404p_per',$arequest->per);

                }     


            }
    }
}

if(defined('SEED_S404P_API_KEY')){
  if(isset($_GET['page']) && $_GET['page'] == 'seed_s404p'){
    add_action( 'admin_init', 'seed_s404p_check_license_updater');
  }
}

