<?php
/**
 * Render Pages
 */


class SEED_S404P{

    /**
     * Instance of this class.
     *
     * @since    1.0.0
     *
     * @var      object
     */
    protected static $instance = null;

	private $s404p_rendered = false;
	private $path = null;

	function __construct(){
            if(!seed_s404p_cu('none')){

            $ts = seed_s404p_get_settings();
            if(!empty($ts) && is_array($ts)){
			 extract($ts);
            }else{
                return false;
            }


            // Actions & Filters if the landing page is active or being previewed
            if(((!empty($status) && $status === '1') || (!empty($status) && $status === '3')) || (isset($_GET['seed_s404p_preview']))){
            	if(function_exists('bp_is_active')){
                    add_action( 'template_redirect', array(&$this,'render_404_page'),9);
                }else{
                    add_action( 'template_redirect', array(&$this,'render_404_page'),99);
                }
                //add_action( 'admin_bar_menu',array( &$this, 'admin_bar_menu' ), 1000 );
            }
            }

        // Deactivate License
        add_action( 'init', array(&$this,'deactivate_license'));


    }

    /**
     * Return an instance of this class.
     */
    public static function get_instance() {

        // If the single instance hasn't been set, set it now.
        if ( null == self::$instance ) {
            self::$instance = new self;
        }

        return self::$instance;
    }



    /**
     * Display admin bar when active
     */
    function admin_bar_menu($str){
        global $seed_s404p_settings,$wp_admin_bar;
        extract($seed_s404p_settings);

        if(!isset($status)){
            return false;
        }

        $msg = '';
        if($status == '1'){
        	$msg = __('404 Mode Active','seedprod-404-page-pro');
        }
        elseif($status == '3'){
        	$msg = __('404 Redirect Mode Active','seedprod-404-page-pro');
        }

    	//Add the main siteadmin menu item
        $wp_admin_bar->add_menu( array(
            'id'     => 'seed-cspcom-notice',
            'href' => admin_url().'options-general.php?page=seed_s404p',
            'parent' => 'top-secondary',
            'title'  => $msg,
            'meta'   => array( 'class' => 'seed-s404p-mode-active' ),
        ) );
    }

    /**
     *  Deactivate License
     */
    function deactivate_license(){
        $token = get_option('seed_s404p_token');
        $seed_s404p_api_key = '';
          if(defined('SEED_S404P_API_KEY')){
              $seed_s404p_api_key = SEED_S404P_API_KEY;
          }
          if(empty($seed_s404p_api_key)){
              $seed_s404p_api_key = get_option('seed_s404p_license_key');
          }

        if(((isset($_REQUEST['seed_s404p_token']) && $_REQUEST['seed_s404p_token'] == $token) || isset($_REQUEST['seed_s404p_token']) && $_REQUEST['seed_s404p_token'] == $seed_s404p_api_key) && (isset($_REQUEST['seed_s404p_action']) && $_REQUEST['seed_s404p_action'] == 'deactivate')) {
                    $seed_s404p_per = '';
                    if(!empty($_REQUEST['seed_s404p_per'])){
                        $seed_s404p_per = $_REQUEST['seed_s404p_per'];
                    }

                    $seed_s404p_api_nag='Site Deactivated';
                    if(!empty($_REQUEST['seed_s404p_api_nag'])){
                        $seed_s404p_api_nag = $_REQUEST['seed_s404p_api_nag'];
                    }

                    update_option('seed_s404p_api_nag',$seed_s404p_api_nag);
                    update_option('seed_s404p_api_message',$seed_s404p_api_nag);
                    update_option('seed_s404p_a',false);
                    update_option('seed_s404p_per',$seed_s404p_per);
                    update_option('seed_s404p_license_key','');

                    echo 'true';

            exit();
        }
    }




    /**
     * Display the default template
     */
    function get_default_template(){
        $file = file_get_contents(SEED_S404P_PLUGIN_PATH.'/themes/default/index.php');
        return $file;
    }


 

    /**
     * Display the coming soon page
     */
    function render_404_page() {


        // Setting
        $plugin_settings = seed_s404p_get_settings();
        extract($plugin_settings);

        // Page Info
        $page_id = 0;
        if(isset($_GET['seed_s404p_preview'])){
            $page_id = $_GET['seed_s404p_preview'];
        }else{
            //Get Coming Soon Page Id
            $page_id = get_option('seed_s404p_s404_page_id');
        }

        // Get Page
        global $wpdb;
        $tablename = $wpdb->prefix . SEED_S404P_PAGES_TABLENAME;
        $sql = "SELECT * FROM $tablename WHERE id= %d";
        $safe_sql = $wpdb->prepare($sql,$page_id);
        $page = $wpdb->get_row($safe_sql);

        // Check for base64 encoding of settings
        if ( base64_encode(base64_decode($page->settings, true)) === $page->settings){
            $settings = unserialize(base64_decode($page->settings));
        } else {
            $settings = unserialize($page->settings);
        }




        // Check  for languages
        if(seed_s404p_cu('ml')){
            $lang_settings_name = 'seed_s404p_'.$page_id.'_language';
            $lang_settings = get_option($lang_settings_name);
            if(!empty($lang_settings)){
                $lang_settings = maybe_unserialize($lang_settings);
                $langs = array('0'=>$lang_settings['default_lang']['label']);
                foreach($lang_settings as $k => $v){
                    if(substr( $k, 0, 5 ) === "lang_"){
                        $langs[$k] = $v['label'];
                    }
                }
            }

            $lang_id = '';
            if(!empty($_GET['lang'])){
                $lang_id = $_GET['lang'];
            }

            // if(isset($_GET['lang'])){
            //     var_dump($_GET);
            //     die();
            // }

            // Get lang settings
            $lang_settings_name = 'seed_s404p_'.$page_id.'_language_'.$lang_id;
            $lang_settings = get_option($lang_settings_name);
            if(!empty($lang_settings)){
                $lang_settings = maybe_unserialize($lang_settings);
            }

            if(!empty($lang_id) && !empty($lang_settings)){
                $settings = array_merge($settings, $lang_settings);
            }
        }
        // var_dump($settings);
        // die();


        // if(!isset($status)){
        //     $err =  new WP_Error('error', __("Please enter your settings.", 'seedprod-404-page-pro'));
        //     echo $err->get_error_message();
        //     exit();
        // }


        // Check if Preview
        $is_preview = false;
        if ((isset($_GET['seed_s404p_preview']))) {
            //show_admin_bar( false );
            $is_preview = true;
        }



        // Exit if feed and feedburner is enabled.
        if(is_feed() && $emaillist == 'feedburner' ){
            return false;
        }

  

        if($is_preview == false){
        if(!empty($include_exclude_options) && $include_exclude_options == '2'){
        if(substr($include_url_pattern, 0, 3) != '>>>'){
        // Check for included pages
            if(!empty($include_url_pattern)){
                //$url = preg_replace('/\?ref=\d*/','',$_SERVER['REQUEST_URI']);
                // TODO lok for when wordpress is in sub folder
                $request_uri = explode('?',$_SERVER['REQUEST_URI']);
                $url = rtrim(ltrim($request_uri[0], '/'),'/');

                $r = array_intersect(explode('/',$url),explode('/',home_url()));

                $url = str_replace($r,'',$url);

                $url = str_replace('/','',$url);
                //var_dump($url);

                $include_urls = explode("\r\n",$include_url_pattern);
                $include_urls = array_filter($include_urls);
                $include_urls = str_replace(home_url(),"",$include_urls);
                $include_urls = str_replace('/','',$include_urls);
                //$include_urls = array_filter($include_urls);
                if(is_array($include_urls) && in_array($url,$include_urls)){
                }else{
                    return false;
                }
            }
        }else{
            // Check for included pages regex
            $include_url_pattern = substr($include_url_pattern, 3);
            if(!empty($include_url_pattern) && @preg_match("/{$include_url_pattern}/",$_SERVER['REQUEST_URI']) == 0){
                return false;
            }
        }
        }

        // Check for excludes pages
        if(!empty($include_exclude_options) && $include_exclude_options == '3'){
        if(substr($exclude_url_pattern, 0, 3) != '>>>'){
            if(!empty($exclude_url_pattern)){
                //$url = preg_replace('/\?ref=\d*/','',$_SERVER['REQUEST_URI']);
                $request_uri = explode('?',$_SERVER['REQUEST_URI']);
                $url = rtrim(ltrim($request_uri[0], '/'),'/');

                $r = array_intersect(explode('/',$url),explode('/',home_url()));

                $url = str_replace($r,'',$url);

                $url = str_replace('/','',$url);
                //var_dump($url);

                $exclude_urls = explode("\r\n",$exclude_url_pattern);
                $exclude_urls = array_filter($exclude_urls);
                $exclude_urls = str_replace(home_url(),"",$exclude_urls);
                $exclude_urls = str_replace('/','',$exclude_urls);
                //$exclude_urls = array_filter($exclude_urls);
                if(is_array($exclude_urls) && in_array($url,$exclude_urls)){
                    return false;
                }
            }


        }else{

            // Check for excluded pages
            $exclude_url_pattern = substr($exclude_url_pattern, 3);
            if(!empty($exclude_url_pattern) && @preg_match("/{$exclude_url_pattern}/",$_SERVER['REQUEST_URI']) > 0){
               return false;
            }
        }
        }
        }


        // Check if redirect url and exclude
        if($status == '3' && !empty($redirect_url)){
            $r_url = parse_url($redirect_url);
            if($r_url['host'] == $_SERVER['HTTP_HOST'] && $r_url['path'] == $_SERVER['REQUEST_URI'] && $is_preview == false){
                return false;
            }
        }




        if($is_preview == false){
            if(!is_404()){
                return false;
            }
        }


        // Finally check if we should show the 404 page.
        $this->s404p_rendered = true;

        // set headers
        if($status == '3' && $is_preview == false){
            if(!empty($redirect_url)){
                wp_redirect( $redirect_url, 301 );
                exit;
            }else{
                echo __( "Please create enter your redirect url in the plugin settings.", "seedprod-404-page-pro" );
                exit();
            }
        }else{
            if(empty($settings)){
                echo __( "Please create your 404 Page in the plugin settings.", "seedprod-404-page-pro" );
                exit();
            }
            if($is_preview == false){
                header("HTTP/1.0 404 Not Found");
            }else{
                header("HTTP/1.0 200 OK");
            }
            
            header('Cache-Control: max-age=0; private');
        }



        // render
        $upload_dir = wp_upload_dir();
       	if(is_multisite()){
			$path = $upload_dir['baseurl'].'/seedprod/'.get_current_blog_id().'/template-'.$page_id.'/index.php';
		}else{
			$path = $upload_dir['basedir'].'/seedprod/template-'.$page_id.'/index.php';
		}

        if(!empty($page->html)){
            echo $page->html;
        }else{

    		if(file_exists($path)){
    		    require_once($path);
    		}else{
    		    require_once(SEED_S404P_PLUGIN_PATH.'template/index.php');
    		}
        }

        exit();

    }

}
