<?php

function ct_replace_ids_attachments_content($data, $attachment_ids) {
    preg_match("/[0-9,]+/", $data, $match);
    if(is_numeric($match[0])) {
        $match_id = $match[0];
        $str=str_replace($match_id,$attachment_ids[$match_id],$data);
    } else {
        $match_ids = explode(',',$match[0]);
        $copy_item = $data;
        foreach ($match_ids as $match_id) {
            if($attachment_ids[$match_id]) {
                $copy_item=str_replace($match_id,$attachment_ids[$match_id],$copy_item);
            } else {
                $copy_item=str_replace($match_id.',','',$copy_item);
            }
        }
        $str=$copy_item;
    }
    $result = preg_replace('/[^0-9,]+/','',$str);
    return $result;
}

function ct_get_ids_attachment ($arr) {
    $query = new WP_Query( array('order' => 'ASC', 'post_status' => 'any', 'post_type' => 'attachment', 'posts_per_page'=>-1 ) );
    $upload_dir = wp_upload_dir();
    $data=array();
    while ( $query->have_posts() ) {
        $query->the_post();
        $data[get_the_ID()] = str_replace($upload_dir['baseurl'],'', wp_get_attachment_url());
    }
    $result = array();
    foreach ($arr as $id=>$src) {
        if($search_id = array_search($src, $data)) {
            $result[$id]=$search_id;
        }
    }
    return $result;
}

function ct_replace_attachments_content($content, $attachment_json_data) {
    preg_match_all("/{{SRC_ID_[0-9,]+}}/s", $content, $matches);
    if(!empty($matches[0])) {
        foreach ($matches[0] as $item) {
            $replace=ct_replace_ids_attachments_content($item, $attachment_json_data);
            if(!empty($replace)) {
                $content = str_replace($item, $replace, $content);
            }
        }
    }
    return $content;
}


function ct_get_product_categories_ids($arr) {
    $product_categories = get_terms('product_cat');
    $data = array();
    foreach ($product_categories as $category) {
        $data[$category->term_id]=$category->slug;
    }
    $result = array();
    foreach ($arr as $id=>$src) {
        if($search_id = array_search($src, $data)) {
            $result[$id]=$search_id;
        }
    }
    return $result;
}

function ct_replace_ids_product_categories($data, $categories_ids) {
    $data = str_replace(' ','', $data);
    preg_match("/[0-9,]+/", $data, $match);
    if(is_numeric($match[0])) {
        $match_id = $match[0];
        $str=str_replace($match_id,$categories_ids[$match_id],$data);
    } else {
        $match_ids = explode(',',$match[0]);
        $copy_item = $data;
        foreach ($match_ids as $match_id) {
            if($categories_ids[$match_id]) {
                $copy_item=str_replace($match_id,$categories_ids[$match_id],$copy_item);
            } else {
                $copy_item=str_replace($match_id.',','',$copy_item);
            }
        }
        $str=$copy_item;
    }
    $result = preg_replace('/[^0-9,]+/','',$str);
    $result = 'ids="'.str_replace(',',', ', $result).'"';
    return $result;
}

function ct_replace_product_categories_content($content, $product_categories_data) {
    preg_match_all("/CAT_IDS=\"[0-9, ]+\"/s", $content, $matches);
    if(!empty($matches[0])) {
        foreach ($matches[0] as $item) {
            $replace=ct_replace_ids_product_categories($item, $product_categories_data);
            if(!empty($replace)) {
                $content = str_replace($item, $replace, $content);
            }
        }
    }
    return $content;
}

function sort_array_for_single_item($array) {
    uasort($array, function($a,$b){
        if(!empty($a['parent']) && !empty($b['parent']))  {
            return strcmp($a['parent'], $b['parent']);
        } elseif(!empty($a['title']) && !empty($b['title'])) {
        return strcmp($a['title'], $b['title']);
                }
            });
    return $array;
}

function ct_parse_ids_request($ids) {
    parse_str($ids, $ids_source);
    $ids_array = array();
    foreach ($ids_source as $key => $value) {
        foreach ($value as $single_ids) {
            $single_id_row = explode(',', $single_ids);
            foreach ($single_id_row as $single_id) {
                $ids_array[] = $single_id;
            }
        }
    }
    return array_unique($ids_array);
}